<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class VolunteerOrganize extends Model 
{

    protected $table = 'volunteer_organizes';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('requirement_answer_id', 'orgnize_name_ar', 'orgnize_name_en', 'hours', 'location');

    public function requirement_answer()
    {
        return $this->belongsTo('App\Models\RequirementAnswer');
    }

    public function city()
    {
        return $this->belongsTo('App\Models\City');
    }

}